
// MFCApplication1Dlg.cpp: Implementierungsdatei
//

#include "pch.h"
#include "framework.h"
#include "MFCApplication1.h"
#include "MFCApplication1Dlg.h"
#include "afxdialogex.h"

//*********************************************************************************//
//*********************************************************************************//
//*********************************************************************************//
//HEADER FILE vom BVMODUL
//*********************************************************************************//
#include "mtk_bvm.h"		
//*********************************************************************************//
//*********************************************************************************//
//*********************************************************************************//



#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg-Dialogfeld für Anwendungsbefehl "Info"

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialogfelddaten
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Unterstützung

// Implementierung
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// Example_bvmodul-Dialogfeld



Example_bvmodul::Example_bvmodul(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFCAPPLICATION1_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void Example_bvmodul::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_START_BV, startbv);
	DDX_Control(pDX, IDC_CLOSE_BV, closebv);
	DDX_Control(pDX, IDC_BV_NR, bvnr);
	DDX_Control(pDX, IDC_MSS_LISTE, mss);
	DDX_Control(pDX, IDC_LFD_BV, lfd);
	DDX_Control(pDX, IDC_LFD2_BV, lfd2);
}

BEGIN_MESSAGE_MAP(Example_bvmodul, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_START_BV, &Example_bvmodul::OnBnClickedStartBv)
	ON_BN_CLICKED(IDC_CLOSE_BV, &Example_bvmodul::OnBnClickedCloseBv)
	ON_BN_CLICKED(IDC_MSS_BV, &Example_bvmodul::OnBnClickedMssBv)
	ON_BN_CLICKED(IDC_TRIGGER_BV, &Example_bvmodul::OnBnClickedTriggerBv)
	ON_BN_CLICKED(IDC_TRIGGER2_BV, &Example_bvmodul::OnBnClickedTrigger2Bv)
	ON_BN_CLICKED(IDC_LFD_BV, &Example_bvmodul::OnBnClickedLfdBv)
	ON_BN_CLICKED(IDC_LFD2_BV, &Example_bvmodul::OnBnClickedLfd2Bv)
	ON_BN_CLICKED(IDOK, &Example_bvmodul::OnBnClickedOk)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_HIDE, &Example_bvmodul::OnBnClickedHide)
	ON_BN_CLICKED(IDC_RESTORE, &Example_bvmodul::OnBnClickedRestore)
	ON_BN_CLICKED(IDC_WINPOS, &Example_bvmodul::OnBnClickedWinpos)
END_MESSAGE_MAP()


// Example_bvmodul-Meldungshandler

BOOL Example_bvmodul::OnInitDialog()
{
	int i;
	wchar_t buffer[256];


	CDialogEx::OnInitDialog();

	// Hinzufügen des Menübefehls "Info..." zum Systemmenü.

	// IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Symbol für dieses Dialogfeld festlegen.  Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Großes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden


	////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////
	//Liste mit max. 10 Modulnummer
	bvnr.ResetContent();
	for (i = 1; i <= 10; i++)
	{
		swprintf_s(buffer, L"%d", i);
		bvnr.AddString(buffer);
	}
	bvnr.SetCurSel(0);	//Modul1 vorwählen
	//Liste mit max. 50 Messungen 
	mss.ResetContent();
	for (i = 1; i < 50; i++)
	{
		swprintf_s(buffer, L"%d", i);
		mss.AddString(buffer);
	}
	MSSINDEX = 1;		//aktuell gewählter Messwertindex - Messung "1" vorwählen
	mss.SetCurSel(0);
	////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////


	
	return TRUE;  // TRUE zurückgeben, wenn der Fokus nicht auf ein Steuerelement gesetzt wird
}


void Example_bvmodul::OnClose()
{
	KillTimer(1); KillTimer(2); waittime(100);
	close_bvmodul(0);    //0=alle schließen
	CDialogEx::OnClose();

	
}
void Example_bvmodul::OnBnClickedCancel()
{
	KillTimer(1); KillTimer(2); waittime(100);
	close_bvmodul(0);    //0=alle schließen
	CDialogEx::OnCancel();
}
void Example_bvmodul::OnBnClickedOk()
{
	KillTimer(1); KillTimer(2); waittime(100);
	close_bvmodul(0);    //0=alle schließen
	CDialogEx::OnOK();
}



void Example_bvmodul::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// Wenn Sie dem Dialogfeld eine Schaltfläche "Minimieren" hinzufügen, benötigen Sie
//  den nachstehenden Code, um das Symbol zu zeichnen.  Für MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch ausgeführt.

void Example_bvmodul::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gerätekontext zum Zeichnen

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Symbol in Clientrechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// Die System ruft diese Funktion auf, um den Cursor abzufragen, der angezeigt wird, während der Benutzer
//  das minimierte Fenster mit der Maus zieht.
HCURSOR Example_bvmodul::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void Example_bvmodul::OnBnClickedStartBv()
{
	wchar_t buffer[256];
	
	//lese/wähle  aktuelle Nummer für das BV 
	BVNR = bvnr.GetCurSel() + 1;
	//prüfe, ob eine spezielle Konfigurationsdatei gewählt wurde?
	GetDlgItemText(IDC_CFGFILE, buffer, 256);

	//Starte das Modul mit der gewählten Nummer
	if (wcslen(buffer) < 1)	//keine spez. Konfigurationsdatei vorgegeben:
	{
		if (find_bvmodul(BVNR) == 0)
		{
			start_bvmodul(BVNR);
			//run_bvmodul(BVNR);
		}
	}
	else
	{
		if (find_bvmodul(BVNR) == 0)
		{
			start_bvmodulW(BVNR, buffer);	//wenn "buffer" vom Typ wchar_t
			//start_bvmodulA(BVNR, buffer);	//wenn "buffer" vom Typ char
			//run_bvmodul(BVNR);
		}
	}
	
}
void Example_bvmodul::OnBnClickedCloseBv()
{
	//lese/wähle  aktuelle Nummer für das BV 
	BVNR = bvnr.GetCurSel() + 1;
	if (find_bvmodul(BVNR) == 1)
	{
		stop_bvmodul(BVNR);
		close_bvmodul(BVNR);	//das gewählte Modul löschen -> entfernen
	}
}
void Example_bvmodul::OnBnClickedMssBv()
{
	int i;
	int ret;
	wchar_t buffer[256];
	wchar_t buffer2[500];

	//Liste der Messungen in diesem BV-Modul aktualisieren
	BVNR = bvnr.GetCurSel() + 1;
	MSSINDEX = mss.GetCurSel() + 1;
	mss.ResetContent();
	for (i = 1; i < 50; i++)
	{
		ret = read_mss_status_bvmodul(BVNR, i, buffer);	//diese Bezeichnung und den Aktivierungsstatus abfragen...
		if (ret < 0)	//Fehler
		{
			return;
		}
		//es werden nur die aktivierten Messungen ausgegeben
		if (ret == 1)	//aktiviert
		{
			swprintf_s(buffer2, L"[%d] %s", i, buffer);
			mss.AddString(buffer2);
		}
		else			//deaktiviert
		{
			mss.AddString(L"");
		}
	}
	//Rücksetzen auf die zuletzt gewählte Messung "MSSINDEX"
	if (MSSINDEX <= 0)	MSSINDEX = 1;
	mss.SetCurSel(MSSINDEX - 1);
	return;
}
void Example_bvmodul::OnBnClickedTriggerBv()
{
	int ret;

	// Einzeltrigger senden an das aktuell gewählte Modul und die aktuell gewählte Messung...
	BVNR = bvnr.GetCurSel() + 1;
	MSSINDEX = mss.GetCurSel() + 1;
	ret = trigger_bvmodul(BVNR, MSSINDEX, false);	//ohne Wartefunktion

}
void Example_bvmodul::OnBnClickedTrigger2Bv()
{
	int ret;

	// alle Trigger senden an das gewählte Modul
	// Einzeltrigger senden an das aktuell gewählte Modul und die aktuell gewählte Messung...
	BVNR = bvnr.GetCurSel() + 1;
	ret = trigger_bvmodul(BVNR, 0, false);	//ohne Wartefunktion

}
void Example_bvmodul::OnBnClickedLfdBv()
{
	//lfd.Hauptwertabfrage on/off
	if (lfd.GetCheck())	//laufende Abfrage ist aktiviert
	{
		SetTimer(1, 100, 0);
	}
	else
	{
		KillTimer(1);
	}
}
void Example_bvmodul::OnBnClickedLfd2Bv()
{
	//lfd.Zusatzwertabfrage on / off
	if (lfd2.GetCheck())	//laufende Abfrage ist aktiviert
	{
		SetTimer(2, 100, 0);
	}
	else
	{
		KillTimer(2);
	}
}

void Example_bvmodul::OnTimer(UINT_PTR nIDEvent)
{
	int ret;
	double value;
	double values[50];
	wchar_t buffer0[256];
	wchar_t buffer1[256];
	wchar_t buffer2[256];
	wchar_t buffer3[256];
	wchar_t buffer4[256];
	wchar_t buffer5[256];
	wchar_t buffer6[256];
	wchar_t buffer7[256];
	wchar_t buffer8[256];
	wchar_t buffer9[256];
	wchar_t buffer10[256];

	if (nIDEvent == 1)
	{
		//KillTimer(1);
		//Hauptmesswert abfragen und Darstellen:
		//int read_bvmodul(int modulindex, int mssindex, double* value)
		BVNR = bvnr.GetCurSel() + 1;
		MSSINDEX = mss.GetCurSel() + 1;
		ret = read_main_value_bvmodul(BVNR, MSSINDEX, &value);	//Abfragen eines Messwertes aus dem Modul 1 mit dem Index 1...
		//diesen Messwert in Dialog ausgeben:
		if (ret == -1)		swprintf_s(buffer0, L"Einrichtungsmodus");
		if (ret == -2)		swprintf_s(buffer0, L"Konfigurationsmodus");
		if (ret == -3)		swprintf_s(buffer0, L"Messung nicht aktiviert");
		if (ret == -4)		swprintf_s(buffer0, L"Fehler bei Messung");
		if (ret == -5)		swprintf_s(buffer0, L"Fehler allg.");
		if (ret == -6)		swprintf_s(buffer0, L"Fehler BV-Modul");
		if (ret == 0)		swprintf_s(buffer0, L"warte....");
		if (ret == 1)		swprintf_s(buffer0, L"%.6f", value);
		SetDlgItemText(IDC_MAINVALUE, buffer0);

	}
	if (nIDEvent == 2)
	{
		BVNR = bvnr.GetCurSel() + 1;
		MSSINDEX = mss.GetCurSel() + 1;
		ret = read_sub_values_bvmodul(BVNR, MSSINDEX, values, 11);	//Abfragen eines Messwertes aus dem Modul 1 mit dem Index 1...
		//lösche alle buffer
		wcscpy_s(buffer0, L"");
		wcscpy_s(buffer1, L"");
		wcscpy_s(buffer2, L"");
		wcscpy_s(buffer3, L"");
		wcscpy_s(buffer4, L"");
		wcscpy_s(buffer5, L"");
		wcscpy_s(buffer6, L"");
		wcscpy_s(buffer7, L"");
		wcscpy_s(buffer8, L"");
		wcscpy_s(buffer9, L"");
		wcscpy_s(buffer10, L"");

		//1:		Messung erfolgreich, Wert (value) kann verarbeitet werden.
		//0:		Messung ist aktiviert/ getriggert aber noch kein Wert vorhanden. Eventuell ist im BV-Modul die Messung angehalten?
		//-1:		Programm befindet sich im Einrichtungsmodus
		//-2:		Programm befindet sich im Konfigurationsmodus
		//-3:		Messung ist nicht aktiviert
		//-4:		Fehler bei der Messung
		//-5:		unspez. Fehler
		if (ret == -1)		swprintf_s(buffer1, L"Einrichtungsmodus");
		if (ret == -2)		swprintf_s(buffer1, L"Konfigurationsmodus");
		if (ret == -3)		swprintf_s(buffer1, L"Messung nicht aktiviert");
		if (ret == -4)		swprintf_s(buffer1, L"Fehler bei Messung");
		if (ret == -5)		swprintf_s(buffer1, L"Fehler allg.");
		if (ret == -6)		swprintf_s(buffer1, L"Fehler BV-Modul");
		if (ret == 0)		swprintf_s(buffer1, L"warte....");
		if (ret == 1)
		{
			//diesen SUB Messwert in Dialog ausgeben:
			swprintf_s(buffer0, L"%.6f", values[0]);
			swprintf_s(buffer1, L"%.6f", values[1]);
			swprintf_s(buffer2, L"%.6f", values[2]);
			swprintf_s(buffer3, L"%.6f", values[3]);
			swprintf_s(buffer4, L"%.6f", values[4]);
			swprintf_s(buffer5, L"%.6f", values[5]);
			swprintf_s(buffer6, L"%.6f", values[6]);
			swprintf_s(buffer7, L"%.6f", values[7]);
			swprintf_s(buffer8, L"%.6f", values[8]);
			swprintf_s(buffer9, L"%.6f", values[9]);
			swprintf_s(buffer10, L"%.6f", values[10]);
		}
		SetDlgItemText(IDC_VALUES_0, buffer0);
		SetDlgItemText(IDC_VALUES_1, buffer1);
		SetDlgItemText(IDC_VALUES_2, buffer2);
		SetDlgItemText(IDC_VALUES_3, buffer3);
		SetDlgItemText(IDC_VALUES_4, buffer4);
		SetDlgItemText(IDC_VALUES_5, buffer5);
		SetDlgItemText(IDC_VALUES_6, buffer6);
		SetDlgItemText(IDC_VALUES_7, buffer7);
		SetDlgItemText(IDC_VALUES_8, buffer8);
		SetDlgItemText(IDC_VALUES_9, buffer9);
		SetDlgItemText(IDC_VALUES_10, buffer10);

		//falls es einen referenzpunkt gibt, dann diesen hier abfragen und anzeigen
		wcscpy_s(buffer0, L"");
		wcscpy_s(buffer1, L"");
		ret = read_ref_values_bvmodul(BVNR, &values[0], &values[1], &values[2]);
		if (ret == 1)
		{
			//diesen SUB Messwert in Dialog ausgeben:
			swprintf_s(buffer0, L"Referenzpunkt:  [%.1f; %.1f]", values[0], values[1]);
			swprintf_s(buffer1, L"Referenzwinkel: %.2f", values[2]);
		}
		SetDlgItemText(IDC_REFPKT, buffer0);
		SetDlgItemText(IDC_REFW, buffer1);
	}

	CDialogEx::OnTimer(nIDEvent);

}
void Example_bvmodul::waittime(DWORD t)
{
	ULONGLONG TickCount;
	MSG  Msg;

	if (t == 0)
	{
		if (PeekMessage(&Msg, 0, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&Msg);
			DispatchMessage(&Msg);
		}
		return;
	}
	if (t < 50)
	{
		Sleep(t);
		if (PeekMessage(&Msg, 0, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&Msg);
			DispatchMessage(&Msg);
		}
		return;
	}
	else
	{
		TickCount = GetTickCount64();
		do
		{

			if (PeekMessage(&Msg, 0, 0, 0, PM_REMOVE))
			{
				TranslateMessage(&Msg);
				DispatchMessage(&Msg);
			}
			else
			{
				//da keine Messages anliegen wird etwas gewartet!
				Sleep(10);
			}
			//evt. Fehler da Überlauf nach 49 Tagen - Risiko minimal da Rechner maximal 5 Tage läuft!
			//wenn doch wird Schleife sofort verlassen, da DWORD immer positiv!
		} while (GetTickCount64() - TickCount < (ULONGLONG)t);
	}
}




void Example_bvmodul::OnBnClickedHide()
{
	ShowWindow_bvmodul(BVNR, 0);
}


void Example_bvmodul::OnBnClickedRestore()
{
	ShowWindow_bvmodul(BVNR, 1);
}


void Example_bvmodul::OnBnClickedWinpos()
{
	wchar_t buffer[25];
	int x, y, cx, cy;

	GetDlgItemText(IDC_X, buffer, 5); x = _wtoi(buffer);
	GetDlgItemText(IDC_Y, buffer, 5); y = _wtoi(buffer);
	GetDlgItemText(IDC_CX, buffer, 5); cx = _wtoi(buffer);
	GetDlgItemText(IDC_CY, buffer, 5); cy = _wtoi(buffer);

	SetWindowPos_bvmodul(BVNR, x, y, cx, cy);

}
