#pragma once

#ifdef MTKBVLIBRARY_EXPORTS
#define MTKBVLIBRARY_API __declspec(dllexport)
#else
#define MTKBVLIBRARY_API __declspec(dllimport)
#endif


//gltig fr MTK_BVM.dll (MTK_BVM.lib) ab Version 2.1

//Versionsinfos:
//2.1 (10.06.2023)
//DLL Start mit vorgegebener Konfigurationsdatei:
// - Es kann wahlweise nur der Dateiname oder der kompletter Dateipfad vorgegeben werden (begrenzung auf Text mit max. 2000 Zeichen). 
//Messwerttrigger ber DLL Funktion:
// - "laufende" oder "zeitgesteuerte" Trigger im Prfplan sind oft nicht geeignet bei gezielter Messwerterfassung ber DLL-Abfragen, 
//   weil nicht synchron und mit erheblichen Resourcenverbrauch. Besser: diese Trigger mit DLL-Funktion temporr deaktivieren und DLL-Trigger verwenden.
//Aufnahme und Speichern von Bitmaps:
// - neue DLL-Funktion um das aktuelle Kamerabild in bel. Ordner/Dateiname zu speichern.
//Sonstiges:
// - Sicherheitsroutinen zum Schlieen des Fensters bei DLL-Start
// - zufllige Programmfehler bei Merkmalen mit "Mehrfachmessung... Mittelwertbildung usw."

//2.1 (23.06.2023)
// Problem: wenn DLL Abfrage read_main_value_bvmodul() und Messung z.Z. luft ...-> return(0)
// Lsung: read_main_value_bvmodul() liefert den aktuell zuletzt gemessenen Wert (Zyklenwert) + return(1) oder return(0) wenn Wert noch gar nicht gemessen
//         read_main_value_bvmodul() liefert sofort return(-1) wenn aktueller Wert fehlerhaft.
// 
// Problembeseitigung:	bei mehreren GX-Kamera wird LIB erst geschlossen wenn es kein MODUL mehr gibt, welches diese LIB gerade verwendet. 
//						geladen wird die LIB nur, wenn nicht bereits in anderen Modul geschehen
// Mehrfachmessung:	Tabelle um Eintrag "-" ergnzt! Damit erfolgt KEINE Mehrfachmessung; Auswahlfeld fr Anzahl der Messungen wird damit deaktiviert


//Versionsinfos:
//2.1 (11.07.2023)
// Fehler bei DLL_TRIGGER+ Mehrfachzyklen beseitigt (Wartet bis alle Zyklen fertig)
// Darstellungsfehler in Messwerttabelle und Senden von Messwerten beseitigt: Wenn letzter Wert fehlerhaft ist Rckgabeindex=-4 (auch wenn Zykluswert noch OK)
// Fehlerbeseitigung: Wenn Keine Mehrfachmessung ausgewhlt wird Zyklenanzahl auf 1 gesetzt. (Sonderfall Geschwindigkeitsmessung - da immer zyklen=2)

//Versionsinfos:
//2.1 (21.07.2023)
// bessere Erkennung ob cfg-Dateivorgabe mit oder ohne Pfad
// Wenn cfg-Datei nicht gefunden -> Dateidialog: Auswahl einer vorhandenen cfg + kopieren in neue cfg  (bei Fehler verwendet temp.cfg im A_VERZ)
// wenn bmp-datei nicht gefunden -> Dateidialog: Auswahl bmp+ Pfad -> schreibe in cfg den neuen Pfad/name

//2.2 (30.07.2023)
// Skalierungserkennung vom Monitor ergnzt -> Koordinaten von Schaltfeldern werden entsprechend korrigiert. Dazu shcore.lib ergnzt!

//2.2 (11.08.2023)
//mindestgre bei Mustererkennung auf 2x3 Pixel verringert 

//2.3 (30.10.2023)
//Fehler (ab Version 2.2(11.07.23))  in Funktion: "trigger_bvmodul(,,true)" beseitigt.
//Die Funktion "stop_bvmodul" beendet auch unverzglich die Funktion: "trigger_bvmodul(,,true)"
//Ziffernerkennung fr Muster verbessert: Vergrertes Dialogfenster + Anzeige aller Vergleichsmuster 
//Anzeige Triggerstatus + manuelle Triggerauslsung (rechts/unten)

//2.3 (15.11.2023)
//Fehler bei Trigger "trigger_bvmodul(,,true)" mit Warteoption beseitigt + Funktion wartet auf neues Kamerabild!
//Hinweis: Der sehr schnelle fortlaufende Aufruf von "trigger_bvmodul(,,false )" - ohne Wartefunktion- kann zum Blockieren des Livebildes fhren! 

// 2.3 (28.04.2024)
//neue "7 Segment" Zahlen - Funktion
//"Kantenabstand" berarbeitet / neue Berechnung; verbesserte Darstellung; Parameter.....

//2.4 (18.08.2025)
//Fehler bei Bildkorrektur fr subpixel beseitigt (bisher immer Rundung auf Pixelgenauigkeit)
//Auswertung von Injektionsflaschen 
//gut/Schlecht Bewertung von Kennwerten
//RS232 funktionsaufruf fr externes Gert

//2.5 (03.09.2025)
//Auswertung von Rollrandflaschen 


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//verschiedene Varianten um ein BV-Modul zu starten/ffnen
//ohne Dateivorgabe wird "bvmodul_1.cfg" (..... "bvmodul_10.cfg") verwendet
//mit Dateiname (optional mit kompletten Dateipfad) NEU!!!
//Rckgabewert:
// 1  = Modul erfolgreich gestartet
// -1 = Modul existiert bereits (kann nicht 2x gestartet werden!)
// -2 = ungltiger Modulindex
extern "C" MTKBVLIBRARY_API int start_bvmodul(int modulindex);						//nur mit gltigem Modulindex (1...10)
extern "C" MTKBVLIBRARY_API int start_bvmodulW(int modulindex, wchar_t file[2048]);	//mit Modulindex + Konfigurationsdatei (Unicode)
extern "C" MTKBVLIBRARY_API int start_bvmodulA(int modulindex, char file[2048]);		//mit Modulindex + Konfigurationsdatei (ascii)
//schlieen/beenden 
extern "C" MTKBVLIBRARY_API void close_bvmodul(int modulindex);						//0=alle schlieen oder mit gltigem Modulindex (1...10)
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Spezialfunktionen:
//Abfragefunktion: Modul bereits vorhanden? 0=irgendein Modul  1..10 Prfe auf dieses Modul
//Rckgabewert:
// 0  = Modul ist nicht gestartet
// 1  = Modul ist gestartet
// find_bvmodul(0) = Rckgabewert ist der Index vom ersten gefundenen Modul (1...10)  oder "0" wenn Kein Modul gefunden
extern "C" MTKBVLIBRARY_API int find_bvmodul(int modulindex);

// Sprache voreinstellen (Diese Funktion hat  Prioritt gegenber der Sprachauswahl im Konfigurationsmen)
// SetLanguage_bvmodul() vor start_bvmodul() aufrufen, um die Programmsprache fr alle Module vorab zu definieren
extern "C" MTKBVLIBRARY_API void SetLanguage_bvmodul(int mode);	// 0=Deutsch  1=Englisch




//Nach dem "START" eines BV-Moduls befindet dieses noch im "STOP" Zustand! D.h. das Livebild wird angezeigt, es erfolgt aber keine Reaktion auf Triggersignale!
//Zwischen "STOP" und  "RUN" Zustand kann im Dialogfenster oder ber die folgenden Befehle gewechselt werden:
//Rckgabewert: 
// 1  = OK
//-2  = ungltiger Modulindex
//-6  = Modulfehler
extern "C" MTKBVLIBRARY_API int run_bvmodul(int modulindex);
extern "C" MTKBVLIBRARY_API int stop_bvmodul(int modulindex);

//Kamerabild wird zunchst immer "live" dargestellt, kann ber diese Kommandos "eingefroren/angehalten" werden (nicht verfgbar fr Modus: BMP und SCREEN).
//Rckgabewert: 
// 1  = OK
//-2  = ungltiger Modulindex
//-6  = Modulfehler
extern "C" MTKBVLIBRARY_API int live_bvmodul(int modulindex);
extern "C" MTKBVLIBRARY_API int freeze_bvmodul(int modulindex);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Folgende Parameter fr die Darstellung des Fensters gelten nur temporr. Nach einem Neustart werden wieder die Vorgabewerte verwendet.
//Darstellung vom BV-Modul festlegen (unsichtbar/sichtbar)
extern "C" MTKBVLIBRARY_API void ShowWindow_bvmodul(int modulindex, int mode);		//0=unsichtbar (HIDE)	 1=sichtbar (RESTORE)
//Darstellung vom BV-Modul festlegen  (Fenstergre und -position ndern/festlegen)
extern "C" MTKBVLIBRARY_API void SetWindowPos_bvmodul(int modulindex, int x, int y, int cx, int cy);	//links/oben/Breite/Hhe
//Darstellung vom BV-Modul festlegen  (Anordnung im Hintergrund, Vordergrund...)
extern "C" MTKBVLIBRARY_API void SetWindowStyle_bvmodul(int modulindex, int mode);		// 0 = im Hintergrund (nicht aktiviert)    1=berlappend  2=immer im Vordergrund (topmost)




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// BV-Modul Trigger fr eine Messwerterfassung auslsen -> warte bis Messung fertig ja/nein
// bergabewerte:
// modulindex= 1,2...10   Kamera/Modulnummer
// mssindex= 0			//es wird ein Trigger fr die Messung von "allen" aktivierten Messungen ausgelst
// mssindex= 1,2.....50	//es wird ein Trigger fr eine spezifische Messung ausgelst
// wait= true			// Funktion wird erst beendet, wenn neues Bild aufgenommen + wenn Messung fertig  (timeout nach 1000ms)
// wait= false			// Funktion wird sofort beendet
//Rckgabewert:
// 0  = kein aktivierter Messwert vorhanden
// 1  = OK
// -1 = allg. Fehler 
// -2 = timeout (nach ca. 1000 ms)
// -3 = alle Messungen sind z.Z. gestoppt
// -6 = Modulfehler
extern "C" MTKBVLIBRARY_API int trigger_bvmodul(int modulindex, int mssindex, bool wait);



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//NEU ab Version 2.1 (100523)
// 
// BV-Modul programmierte interne Trigger deaktivieren/aktivieren 
//	Wird das BV_Modul von extern getriggert (siehe Funktion: trigger_bvmodul()) sind interne Trigger evtl. ungnstig, weil 
//  schlechte Synchronisierung und unntig hohe Rechenlast vom Modul.
//  Betrifft NUR die Triggertypen: Echtzeit (real) und Timer
// 
// bergabewerte:
// modulindex= 1,2...10   Kamera/Modulnummer   
// mssindex= 0			//es werden alle internen real und timer - Trigger on/off gesetzt
// mssindex= 1,2.....50	//es werden die Trigger fr eine spezifische Messung  on/off gesetzt
//Rckgabewert:
// 0  = Fehler 
// 1  = OK	
//-1  = Kennwert ist ungltig
// -6 = Modulfehler
extern "C" MTKBVLIBRARY_API int set_trigger_off_bvmodul(int modulindex, int mssindex);
extern "C" MTKBVLIBRARY_API int set_trigger_on_bvmodul(int modulindex, int mssindex);



//Abfragen eines HAUPT-Messwertes aus einem Modul Vorgabe: Modulindex & Messwertindex...
//Rckgabe: double Messwert  
//Rckgabewert: 
// 0  = Messung ist aktiviert aber noch kein Messwert vorhanden
// 1  = OK 
//-1  = Kennwert ist nicht aktiviert
//-2  = Fehler bei Messung
//-3  = sonstiger Fehler
//-6  = Modulfehler
extern "C" MTKBVLIBRARY_API int read_main_value_bvmodul(int modulindex, int mssindex, double* value);

//Abfragen von "n" Sub-Ergebnissen (im Bereich von n= 1...49) von einer Messung aus einem Modul Vorgabe: Modulindex & Messwertindex und Anzahl der zu lesenden double-Datenwerte
//Rckgabe: double Datenfeld[50] 
//Rckgabewert: 
// 0  = Messung ist aktiviert aber noch kein Messwert vorhanden
// 1  = OK 
//-1  = Kennwert ist nicht aktiviert
//-2  = Fehler bei Messung
//-3  = sonstiger Fehler
//-6  = Modulfehler
extern "C" MTKBVLIBRARY_API int read_sub_values_bvmodul(int modulindex, int mssindex, double values[], int n);

//Abfragen von Zyklus-Ergebnissen von einer Messung aus einem Modul Vorgabe: Modulindex & Messwertindex 
//Rckgabe: Zeiger auf double Datenfeld[100] 
//Rckgabewert: 
//>=1...100 = Messung erfolgreich, Wert (value) kann verarbeitet werden. Der Rckgabewert entspricht Anzahl der gltigen Werte im Datenfeld.
//  0		= Messung ist aktiviert aber noch kein Messwert vorhanden
// -1		= Programm befindet sich im Einrichtungsmodus
// -2		= Programm befindet sich im Konfigurationsmodus
// -3		= Messung ist nicht aktiviert
// -4		= Fehler bei der Messung
// -5		= unspez. Fehler
// -6		= Modulfehler
extern "C" MTKBVLIBRARY_API int read_zyklus_values_bvmodul(int modulindex, int mssindex, double values[]);

//Abfragen Referenzpunkt aus einem Modul Vorgabe: Modulindex 
//Rckgabe: 3 double Werte (x,y,Drehwinkel)
//Rckgabewert:
// 0  = Messung ist aktiviert aber noch kein Messwert vorhanden
// 1  = OK 
//-1  = Kennwert ist nicht aktiviert
//-2  = Fehler bei Messung
//-3  = sonstiger Fehler
//-6  = Modulfehler
extern "C" MTKBVLIBRARY_API int read_ref_values_bvmodul(int modulindex, double* ref_x, double* ref_y, double* ref_w);

//Abfragen Status von einer Messung (aktiviert?) sowie die interne Bezeichnung fr diese Messung
//Rckgabewert: 
// 0  = Messung ist deaktiviert
// 1  = Messung ist aktiviert
//-6  = Modulfehler
extern "C" MTKBVLIBRARY_API int read_mss_status_bvmodul(int modulindex, int mssindex, wchar_t txt[]);




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// BV-Modul aktuelles Bild wird unter den vorgegebenen Namen/Pfad als bitmap abgespeichert
// - vorhandene Dateien werden ersetzt, noch nicht vorhandene Dateien erzeugt (Pfad muss vorhanden sein!)
// - bei Dateiname (ohne Pfadangabe) wird die Bilddatei in das vordefinierte Bildverzeichnis abgelegt
// bergabewerte:
// modulindex= 1,2...10   Kamera/Modulnummer
// wait=true   Die Funktion wird erst dann beendet, wenn fertig ausgefhrt.
//Rckgabewert:
// 1  = OK
// -1 = allg. Fehler 
// -6 = Modulfehler
extern "C" MTKBVLIBRARY_API int save_bmp_bvmodulW(int modulindex, wchar_t file[2048], bool wait);	//UNICODE Version 
extern "C" MTKBVLIBRARY_API int save_bmp_bvmodulA(int modulindex, char file[2048], bool wait);		//ASCII Version



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// !!!!FUNKTION NUR FR DEN INTERNEN GEBRAUCH !!!!!
extern "C" MTKBVLIBRARY_API int activate_logfile_bvmodul(wchar_t file[2048]);
//liefert das hwnd fr das BV-Modul
extern "C" MTKBVLIBRARY_API long get_hwnd_bvmodul(int modulindex);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////